
#ifndef RADIOPROTOCOL_H_
#define RADIOPROTOCOL_H_

#include "stdint.h"
#include "easylink/EasyLink.h"

#define RADIO_CONCENTRATOR_ADDRESS     0x00
#define RADIO_EASYLINK_MODULATION     EasyLink_Phy_Custom

#define RADIO_PACKET_TYPE_ACK_PACKET            0
#define RADIO_PACKET_TYPE_MOB_TAG_PACKET        1
#define RADIO_PACKET_TYPE_BROADCAST_PACKET      2

struct PacketHeader {
    uint8_t sourceAddress;
    uint8_t packetType;
    uint8_t id[3];
};

struct MOBtagPacket {
    struct PacketHeader header;
    uint8_t randValueH; //for unique address assignment protocol
    uint8_t randValueL; //for unique address assignment protocol
    uint8_t batt;
    uint8_t state;
    uint8_t checksum;
};

struct AckPacket {
    struct PacketHeader header;
    uint8_t randValueH; //for unique address assignment protocol
    uint8_t randValueL; //for unique address assignment protocol
    uint8_t status;
    uint8_t newAddress;
    uint8_t checksum;
};

struct BroadcastPacket {
    struct PacketHeader header;
    uint8_t checksum;
};

#endif /* RADIOPROTOCOL_H_ */
